% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_multi_range.R
\name{geom_multi_range}
\alias{geom_multi_range}
\title{Draw multi-ranges as multiple rectangles on 1D or 2D plot}
\usage{
geom_multi_range(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}

\item{show.legend}{should a legend be drawn? (defaults to \code{FALSE})}
}
\value{
a geom_rect layer
}
\description{
This geom is based on the source code of ' \code{\link{geom_rect}}
}
\details{
The goal is to determine the line to be either vertial or horizontal based on the data provided in
this layer. Also convert input 1D intervals to geom_rect acceptable shapes
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "vline")}
}

