% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqlogo.R
\name{geom_seqlogo}
\alias{geom_seqlogo}
\title{geom_seqlogo}
\usage{
geom_seqlogo(
  font = "DroidSansMono",
  color = "Chemistry_AA",
  adaptive = TRUE,
  top = TRUE,
  custom_color = NULL,
  show.legend = FALSE,
  ...
)
}
\arguments{
\item{font}{font families, possible values are 'helvetical', 'mono', 
and 'DroidSansMono', 'TimesNewRoman'. Defaults is 'DroidSansMono'.}

\item{color}{A Color scheme. One of 'Clustal', 'Chemistry_AA', 
'Shapely_AA', 'Zappo_AA', 'Taylor_AA', 'LETTER', 'CN6', 'Chemistry_NT', 
'Shapely_NT', 'Zappo_NT', 'Taylor_NT'. Defaults is 'Chemistry_AA'.}

\item{adaptive}{A logical value indicating whether the overall height 
of seqlogo corresponds to the number of sequences.If is FALSE, 
seqlogo overall height = 4,fixedly.}

\item{top}{A logical value. If TRUE, seqlogo is aligned to the top of MSA.}

\item{custom_color}{A data frame with two cloumn called "names" and 
"color".Customize the color scheme.}

\item{show.legend}{logical. Should this layer be included in the legends?}

\item{...}{additional parameter}
}
\value{
A list
}
\description{
Multiple sequence alignment layer for ggplot2. It plot sequence motifs.
}
\examples{
#plot multiple sequence alignment and sequence motifs
f <- system.file("extdata/LeaderRepeat_All.fa", package="ggmsa")
ggmsa(f,font = NULL,color = "Chemistry_NT") + geom_seqlogo()
}
\author{
Lang Zhou
}
