% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCoords.R
\name{plotCoords}
\alias{plotCoords}
\alias{plotSpots}
\title{plotCoords}
\usage{
plotCoords(
  spe,
  x_coord = NULL,
  y_coord = NULL,
  sample_id = NULL,
  in_tissue = "in_tissue",
  annotate = NULL,
  feature_names = NULL,
  assay_name = "counts",
  pal = NULL,
  point_shape = 16,
  point_size = 0.3,
  legend_position = "right",
  legend_point_size = 3,
  show_axes = FALSE,
  y_reverse = TRUE,
  text_by = NULL,
  text_by_size = 5,
  text_by_color = "black"
)

plotSpots(...)
}
\arguments{
\item{spe}{Input data, assumed to be a \code{SpatialExperiment} or
\code{SingleCellExperiment} object.}

\item{x_coord}{Name of column in \code{spatialCoords} (for a
\code{SpatialExperiment} input object) or \code{colData} (for a
\code{SingleCellExperiment} input object) containing x coordinates. Default
= NULL (for a \code{SpatialExperiment}, the first column of
\code{spatialCoords} will be selected in this case).}

\item{y_coord}{Name of column in \code{spatialCoords} (for a
\code{SpatialExperiment} input object) or \code{colData} (for a
\code{SingleCellExperiment} input object) containing y coordinates. Default
= NULL (for a \code{SpatialExperiment}, the second column of
\code{spatialCoords} will be selected in this case).}

\item{sample_id}{Name of column in \code{colData} containing sample IDs. This
argument is only required for datasets containing multiple samples (tissue
sections). If provided, samples will be shown in multiple panels using
facetting. Default = NULL.}

\item{in_tissue}{Name of column in \code{colData} identifying spots over
tissue (e.g. "in_tissue" for 10x Genomics Visium datasets). If this
argument is provided, only spots over tissue will be shown. Default =
"in_tissue". Set to NULL to display all spots.}

\item{annotate}{Variable to show as annotations. This may be discrete or
continuous. For a discrete variable (e.g. cluster labels), this should be
the name of a column in \code{colData} containing a character vector or
factor. For a continuous variable (e.g. a gene name), this should be an
entry in \code{feature_names}. Default = NULL.}

\item{feature_names}{Name of column in \code{rowData} containing names of
continuous features to plot (e.g. gene names). For example, set to
\code{feature_names = "gene_name"} if gene names are stored in a column
named \code{"gene_name"}. This argument is used if \code{annotate} is a
continuous variable. Default = NULL, in which case the row names of the
input object will be used.}

\item{assay_name}{Name of \code{assay} in input object containing values to
plot for a continuous variable. Default = "counts".}

\item{pal}{Color palette for annotations. Options for discrete values are
"libd_layer_colors", "Okabe-Ito", or any vector of color names or hex
values. For continuous values, provide a vector of length 2 for the low and
high range, e.g. c("gray90", "navy").}

\item{point_shape}{Point shape. Default = 16, which gives a circular shape
suitable for representing, for example, a Visium spot or Xenium cell. A
value of 15 gives a square shape suitable for Visium HD.}

\item{point_size}{Point size. Default = 0.3.}

\item{legend_position}{Legend position for discrete annotations. Options are
"left", "right", "top", "bottom", and "none". Default = "right".}

\item{legend_point_size}{Legend point size for discrete annotations. Default
= 3.}

\item{show_axes}{Whether to show axis titles, text, and ticks. Default =
FALSE.}

\item{y_reverse}{Whether to reverse y coordinates. This is usually required
for 10x Genomics Visium datasets when using the default coordinate values.
Default = TRUE. Set to FALSE if not needed, e.g. for other platforms.}

\item{text_by}{Column name of annotation labels to display over each cluster
of points. This will usually be the same as \code{annotate}. Alternatively,
another column may be used (e.g. with more readable classes or shorter
strings). Only used for discrete \code{annotate}. Default = NULL.}

\item{text_by_size}{Text size for annotation labels over each cluster.
Default = 5.}

\item{text_by_color}{Color name or hex code for annotation labels. Default =
"black".}

\item{...}{Not used.}
}
\value{
Returns a ggplot object, which may be further modified using ggplot
  functions.
}
\description{
Plotting functions for spatial transcriptomics data.
}
\details{
Function to create spot plot showing spatial locations in x-y coordinates
with optional annotations such as cluster labels, expression of a gene, or
quality control metrics.
}
\examples{
library(STexampleData)

# discrete annotations
spe <- Visium_humanDLPFC()
plotCoords(spe, annotate = "ground_truth")

# continuous annotations
spe <- Visium_mouseCoronal()
plotCoords(spe, annotate = "Gapdh", feature_names = "gene_name")

}
\author{
Lukas M. Weber and Yixing E. Dong
}
