% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{featureDiagram}
\alias{featureDiagram}
\title{Display 'features' of interest in a diagram}
\usage{
featureDiagram(ideogram_data, feature_data, start_degree = 180,
  coverage_rectangle = NULL, coverage_data = NULL,
  custom_sector_width = NULL, space_between_sectors = 4,
  flipped_sector = NULL, sector_colours = nice_colours,
  sector_border_colours = nice_colours, sector_labels = TRUE,
  sector_label_size = 1.3, sector_label_colour = "black",
  label_data = NULL, label_size = 1.1, label_colour = "black",
  xaxis = TRUE, xaxis_label_size = 0.9, xaxis_colour = "#747577",
  xaxis_spacing = 10, feature_label_cutoff = 50,
  xaxis_spacing_unit = "deg", track_height = 0.1,
  feature_label_size = 0.9, link_data = NULL,
  link_colour = "#84c6d6", link_ends = "default", custom_ylim = NULL,
  label_track_height = 0.1 * feature_label_size,
  feature_outline = TRUE)
}
\arguments{
\item{ideogram_data}{Either a \linkS4class{GRanges} representing regions of
interest or a data frame in bed format (containing the \code{chr},
\code{start} and \code{end} columns). If you want to read in data from file,
please see the \code{\link{getIdeogramData}} function.}

\item{feature_data}{A data frame or \linkS4class{GRanges} containing the
'features' to plot. \itemize{
\item GRanges input should contain \code{label}, \code{colour},
\code{shape} and \code{track} as metadata columns.
\item Data frame should contain \code{label}, \code{colour}, \code{shape}
and \code{track}, as well as the additional columns \code{chr}, \code{start}
and \code{end}} Please see below for a detailed description of these
columns, and \code{\link{getFeatures}} for a function which can read this
information in from a .gff file.}

\item{start_degree}{Where on the circle the first sector will start being
drawn from (90 = 12 o'clock).}

\item{coverage_rectangle}{A vector containing the name(s) of any sector(s)
that you would like to depict as 'coverage rectangles': filled in shapes
that are a plot of the coverage data over that sector. See the example below
or the vignette for an example of this.}

\item{coverage_data}{A GRanges (or data frame) containing the coverage data
to plot for those sectors in \code{coverage_rectangle}. To read this data in
from a BAM file, please see the \code{\link{getCoverage}} function.}

\item{custom_sector_width}{Normally, the size of each sector is proportional
to its relative length, but \code{custom_sector_width} can change this. It
is a vector of sector sizes (as proportions of the entire circle), given in
the same order in which sectors are plotted: firstly 'chr1', 'chr2' ...
through to 'chrX' and 'chrY' followed by any differently named sectors e.g.
'gene 1', plasmid' in alphabetical order.}

\item{space_between_sectors}{Space between each sector.}

\item{flipped_sector}{A vector of sectors that will have their genomic
position (x values) reversed (ascending in anti-clockwise direction, as
opposed to the usual ascending in a clock-wise direction).}

\item{sector_colours}{Either a single colour (which will be applied to all
sectors) or a vector with the same length as the number of sectors/regions.
This package includes 5 colour sets: \code{nice_colours},
\code{pastel_colours}, \code{bright_colours_transparent},
\code{bright_colours_opaque} and \code{rich_colours}. See
\code{\link{colourSets}} for more information about these.}

\item{sector_border_colours}{Same as \code{sector_colours}, only for the
border of each sector.}

\item{sector_labels}{If \code{TRUE}, labels ('chr1', 'chr2' etc.) will be
drawn for each sector (recommended).}

\item{sector_label_size}{Size of the sector labels.}

\item{sector_label_colour}{Colour of the sector labels.}

\item{label_data}{Data frame or \linkS4class{GRanges} containing the
labels. If a GRanges, \code{label} should be a metadata column containing
the character strings of the labels. \code{type} and \code{colour} can also
be used to store additional information about the type (e.g. 'gene' or
'promoter') and colour of the label. This information can be used to
\bold{colour code} the labels by supplying the colour column as the
\code{label_colour} parameter. Data frames should additionally include the
\code{chr}, \code{start}, \code{end} which dictate the position of the
label.}

\item{label_size}{Size of the labels.}

\item{label_colour}{Colour of the labels, can be either a single value
(applied to all labels) or a vector with the same length as the number of
labels (for colour-coding).}

\item{xaxis}{If \code{TRUE}, an x (genomic position) xaxis  will be plotted.}

\item{xaxis_label_size}{Size of the x axis labels.}

\item{xaxis_colour}{Colour of the x axis labels.}

\item{xaxis_spacing}{Space between the x axis labels, in degrees.
Alternatively, the string 'start_end' will place a label at the start and
end of each sector only.}

\item{feature_label_cutoff}{To enhance readability when the shapes are
small, those labels belonging to features smaller than
\code{feature_label_cutoff} will instead be plotted on a new track closer
to the centre of the circle, rather than inside the shapes themselves.}

\item{xaxis_spacing_unit}{Either \code{"deg"} to draw ticks every certain
number of degrees around the circle or \code{"bp"} to draw ticks every
certain bp around the circle (be warned that when the scales for each sector
are very different, it's best to use \code{"deg"})}

\item{track_height}{The height (vertical distance around the circle) that
will be taken up by this track. Should be a number between 0 (none) and 1
(entire circle).}

\item{feature_label_size}{Size of the feature labels.}

\item{link_data}{If you would like to draw a link between two sectors of the
circle, \code{link_data} should be a data frame with two rows: one for each
end of the link. There should be 3 columns: \code{chr}, \code{start} &
\code{end} which describe the position of each end of the link.}

\item{link_colour}{The colour of the link: this should be a 6 digit hex
code, the transparency is automatically added.}

\item{link_ends}{How far the link extends in either direction. \emph{This is
set automatically} but if you want to edit it, provide a vector of length 2
with each element being between 0 (centre of circle) and 1 (right at the
edge of the circle).}

\item{custom_ylim}{A vector of length two containing the y (coverage) axis
limits. No need to set if not using coverage rectangles or if you're happy
with the default: c(0, maximum coverage).}

\item{label_track_height}{Size of the track on which to plot the labels.}

\item{feature_outline}{Should a black outline be drawn around the feature
shape? (It is recommended to set this to \code{FALSE} when dealing with
very small features)}
}
\value{
Generates an image of the feature data supplied.
}
\description{
Generates a diagram which displays 'features' (e.g. genes,
indels, primer sequences etc) using coloured shapes. See
\code{\link{insertionDiagram}} for a similar function which specialises in
plotting insertions or \code{\link{drawFeatureTrack}} to add a feature track
to an existing graph.
}
\section{Warning}{

If you choose to use a data frame to supply the feature data, please be
careful to add the \code{stringsAsFactors = FALSE} argument. Otherwise, the
colours may not be correct.
}

\examples{
## plasmid map
plasmid_ideogram <- data.frame(chr='plasmid', start=0, end=2500)

plasmid_features <- GRanges(seqnames=rep('plasmid', 4),
ranges=IRanges(start=c(0, 451, 901, 1700), end=c(450, 900, 1400, 2200)),
colour=c('#d44a9f', '#4a91d4', '#7ad44a', '#d49d4a'),
label=c('promoter', 'gene', 'GFP', 'ampR'),
shape=c('rectangle', 'forward_arrow', 'forward_arrow', 'reverse_arrow'),
track=rep(1, 4))

featureDiagram(plasmid_ideogram, plasmid_features)
}
\seealso{
\code{\link{insertionDiagram}} for a more specialised function
which shows the copy number of insertions. Also
\code{\link{drawFeatureTrack}} to add the exact same feature information to
an existing plot and \code{\link{getFeatures}} for a function that can
read in the feature information from a .gff file.
}
