% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{getIdeogramData}
\alias{getIdeogramData}
\title{Import transgenic genome data from .bam or .fasta file}
\usage{
getIdeogramData(bam_file = NULL, fasta_file = NULL,
  fasta_folder = NULL, just_pattern = NULL, unwanted_chr = NULL,
  wanted_chr = NULL, add_chr = TRUE)
}
\arguments{
\item{bam_file, fasta_file, fasta_folder}{Location of either a .bam file,
.fasta file or folder of .fasta files to read in. You only need to supply
one of these file types; .bam files are recommended because it is much
faster than using .fasta files. Also note that the filters
\code{unwatedChr}, \code{wanted_chr} and \code{just_pattern} won't work with
single .fasta files (only with .bam or .fasta folders).}

\item{just_pattern}{If supplied, this pattern (regex) will be used to select
the sequences to read in}

\item{unwanted_chr}{If supplied, these sequences won't be read in}

\item{wanted_chr}{If supplied, only these sequences will be read in}

\item{add_chr}{If \code{TRUE}, 'chr' will be added to the start of sequence
names with one or two characters (e.g. X will become chrX and 10 will become
chr10 but plasmid will remain as-is)}
}
\value{
A \linkS4class{GRanges} containing the ideogram data (sequence
names, starts & ends).
}
\description{
Read in the seqname, start & end from .bam or .fasta file and
format correctly for plotting with gmoviz.
}
\examples{
## the example .bam file
path <- system.file('extdata', 'ex1.bam', package='Rsamtools')

## just starting with 'seq'
getIdeogramData(bam_file=path, just_pattern='^seq')

## only seq1
getIdeogramData(bam_file=path, wanted_chr='seq1')

## not seq2 (same as above)
getIdeogramData(bam_file=path, unwanted_chr='seq2')

## you can mix and match any of the filters
getIdeogramData(bam_file=path, unwanted_chr='seq2', just_pattern='^seq')

## the function also works to read in individual .fasta files, but please
## note that for now the filters won't work (so if you have multiple
## sequences in one .fasta file then they will all be read in)
path <- system.file('extdata', 'someORF.fa', package='Biostrings')
getIdeogramData(fasta_file=path)

## we can also read in selected .fasta files from a folder of .fasta files,
## based on the filters shown above for the .bam file
path <- system.file('extdata', 'fastaFolder', package='gmoviz')
getIdeogramData(fasta_folder=path)
}
\seealso{
The \code{\link{gmovizInitialise}} and
\code{\link{featureDiagram}} functions which can be used to plot
this data.
}
