% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmoothHeatmap.R
\docType{methods}
\name{smoothHeatmap}
\alias{smoothHeatmap}
\alias{smoothHeatmap,Heatmap-method}
\title{Smooth a heatmap}
\usage{
smoothHeatmap(heatmap, ...)

\S4method{smoothHeatmap}{Heatmap}(heatmap, sigma = c(3, 3),
  output.size = dim(image(heatmap)), algorithm = NULL)
}
\arguments{
\item{heatmap}{A heatmap object}

\item{...}{additional arguments to S4 methods

This function smooths a heatmap using either binned kernel density
(more efficient for binary heatmaps) or gaussian blur.

Sigma controls the SD of the kernel in both cases, defined in terms of
pixels. This means that if you have very diffirent x and y dimensions (eg. a
200bp heatmap around 10000 promoters) you will need to compensate by setting
sigma[2] higher to get the same visual effect in both dimensions

"output.size" specifies the dimensions of the output matrix. This can be
useful to reduce plotting time significantly.

Smoothing can use either a kernel density estimate or a blurring function.
The methods implemented are KernSmooth:bkde2D and EBImage::filter2 with a
gaussian filter. The kernel based method assumes we are smoothing individual
points so the value of these points are ignored. This is most useful for
smoothing PatternHeatmaps where each cell in the matrix is either 1 or 0.
For non-binary heatmaps, blur is most appropriate. Not setting this parameter
will choose the method automatically.

Scaling the output heatmap is handled as in CoverageHeatmap.}

\item{sigma}{Numeric, lengt2, (recycled if length 1)}

\item{output.size}{Numeric, length 2}

\item{algorithm}{"kernel" or "blur"}
}
\value{
A heatmap
}
\description{
Smooth a heatmap
}
\section{Methods (by class)}{
\itemize{
\item \code{Heatmap}: Smooth a heatmap
}}

\examples{
data(HeatmapExamples)
hm_smoothed = smoothHeatmap(hm, sigma=c(5,5), algorithm="blur")
}
