% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential.R
\docType{class}
\name{diff_expression}
\alias{diff_expression}
\alias{HermesDataDiffExpr-class}
\alias{.HermesDataDiffExpr}
\alias{HermesDataDiffExpr}
\alias{autoplot,HermesDataDiffExpr-method}
\title{Differential Expression Analysis}
\usage{
diff_expression(object, group, method = c("voom", "deseq2"), ...)

\S4method{autoplot}{HermesDataDiffExpr}(object, adj_p_val_thresh = 0.05, log2_fc_thresh = 2.5)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input. Note that this function only uses the
original counts for analysis, so this does not need to be normalized.}

\item{group}{(\code{string})\cr name of factor variable with 2 levels in \code{colData(object)}.
These 2 levels will be compared in the differential expression analysis.}

\item{method}{(\code{string})\cr method for differential expression analysis, see details below.}

\item{...}{additional arguments passed to the helper function associated with the selected method.}

\item{adj_p_val_thresh}{(\code{proportion})\cr threshold on the adjusted p-values (y-axis) to
flag significance.}

\item{log2_fc_thresh}{(\code{number})\cr threshold on the absolute log2 fold-change (x-axis)
to flag up- or down-regulation of transcription.}
}
\value{
A \code{\link{HermesDataDiffExpr}} object which is a data frame with the following columns for each gene
in the \code{\link{HermesData}} object:
\itemize{
\item \code{log2_fc} (the estimate of the log2 fold change between the 2 levels of the
provided factor)
\item \code{stat} (the test statistic, which one depends on the method used)
\item \code{p_val} (the raw p-value)
\item \code{adj_p_val} (the multiplicity adjusted p-value value)
}
}
\description{
The \code{diff_expression()} function performs differential expression analysis
using a method of preference.

A corresponding \code{autoplot()} method is visualizing the results as a volcano plot.
}
\details{
Possible method choices are:
\itemize{
\item voom: uses \code{\link[limma:voom]{limma::voom()}}, see \code{\link[=h_diff_expr_voom]{h_diff_expr_voom()}} for details.
\item \code{deseq2}: uses \code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}, see \code{\link[=h_diff_expr_deseq2]{h_diff_expr_deseq2()}} for details.
}
}
\section{Functions}{
\itemize{
\item \code{autoplot(HermesDataDiffExpr)}: generates a volcano plot for a \code{\link{HermesDataDiffExpr}} object.

}}
\note{
\itemize{
\item We provide the \code{\link[=df_cols_to_factor]{df_cols_to_factor()}} utility function that makes it easy to convert the
\code{colData()} character and logical variables to factors, so that they can be subsequently
used as \code{group} inputs. See the example.
\item In order to avoid a warning when using \code{deseq2}, it can be necessary to specify
\code{fitType = "local"} as additional argument. This could e.g. be the case when only few samples
are present in which case the default parametric dispersions estimation will not work.
}
}
\examples{
object <- hermes_data \%>\%
  add_quality_flags() \%>\%
  filter()

# Convert character and logical to factor variables in `colData`,
# including the below used `group` variable.
colData(object) <- df_cols_to_factor(colData(object))
res1 <- diff_expression(object, group = "SEX", method = "voom")
head(res1)
res2 <- diff_expression(object, group = "SEX", method = "deseq2")
head(res2)

# Pass method arguments to the internally used helper functions.
res3 <- diff_expression(object, group = "SEX", method = "voom", robust = TRUE, trend = TRUE)
head(res3)
res4 <- diff_expression(object, group = "SEX", method = "deseq2", fitType = "local")
head(res4)

# Create the corresponding volcano plots.
autoplot(res1)
autoplot(res3)
}
