% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential.R
\name{h_diff_expr_voom}
\alias{h_diff_expr_voom}
\title{\code{limma}/voom Differential Expression Analysis}
\usage{
h_diff_expr_voom(object, design, ...)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input.}

\item{design}{(\code{matrix})\cr design matrix.}

\item{...}{additional arguments internally passed to \code{\link[limma:ebayes]{limma::eBayes()}} (\code{robust}, \code{trend}, \code{proportion},
\code{winsor.tail.p}, \code{stdev.coef.lim}).}
}
\value{
A data frame with columns \code{log2_fc} (estimated log2 fold change),
\code{stat} (moderated t-statistic), \code{p_val} (raw p-value), \code{adj_p_pval} (Benjamini-Hochberg adjusted p-value).
}
\description{
This helper functions performs the differential expression analysis with the voom
method from the \code{limma} package (via \code{\link[limma:voom]{limma::voom()}}, \code{\link[limma:lmFit]{limma::lmFit()}} and \code{\link[limma:ebayes]{limma::eBayes()}})
for given counts in a \link{AnyHermesData} object and a corresponding \code{design} matrix.
}
\examples{
object <- hermes_data

# Create the design matrix corresponding to the factor of interest.
design <- model.matrix(~SEX, colData(object))

# Then perform the differential expression analysis.
result <- h_diff_expr_voom(object, design)
head(result)

# Sometimes we might want to specify method details.
result2 <- h_diff_expr_voom(object, design, trend = TRUE, robust = TRUE)
head(result2)
}
\references{
\insertRef{limma_package}{hermes}

\insertRef{voom_method}{hermes}
}
