% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_corr}
\alias{plot_corr}
\title{Plot correlations}
\usage{
plot_corr(
  cobraplot,
  title = "",
  stripsize = 15,
  titlecol = "black",
  pointsize = 5,
  xaxisrange = c(-1, 1),
  corrtype = "pearson"
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{title}{A character string giving the title of the plot.}

\item{stripsize}{A numeric value giving the size of the strip text, when the
results are stratified by an annotation.}

\item{titlecol}{A character string giving the color of the title.}

\item{pointsize}{A numeric value giving the size of the plot characters.}

\item{xaxisrange}{A numeric vector with two elements, giving the lower and
upper boundary of the x-axis, respectively.}

\item{corrtype}{A character string giving the type of correlation to show.
Either "pearson" or "spearman".}
}
\value{
A ggplot object
}
\description{
Plot correlations between observations and a continuous truth value.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example, cont_truth = "logFC",
                                   aspects = "corr")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_corr(cobraplot, corrtype = "spearman")
}
\author{
Charlotte Soneson
}
