% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_general.R
\name{calculate_adjp}
\alias{calculate_adjp}
\title{Calculate adjusted p-values}
\usage{
calculate_adjp(cobradata, method = "BH")
}
\arguments{
\item{cobradata}{A \code{COBRAData} object.}

\item{method}{A character string giving the method (selected from
\code{p.adjust.methods()}) that will be used to perform the adjustment.}
}
\value{
A \code{COBRAData} object, extended with the calculated adjusted
  p-values.
}
\description{
Calculate adjusted p-values for methods where only nominal p-values are
available in a \code{COBRAData} object.
}
\examples{
data(cobradata_example)
cobradata_example <- calculate_adjp(cobradata_example, method = "BH")
}
\author{
Charlotte Soneson
}
