% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{fsrnbr}
\alias{fsrnbr}
\alias{fsrnbr<-}
\alias{fsrnbr,COBRAPerformance-method}
\alias{fsrnbr<-,COBRAPerformance,data.frame-method}
\alias{fsrnbr,COBRAPlot-method}
\alias{fsrnbr<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{fsrnbr} slot}
\usage{
fsrnbr(x, ...)

fsrnbr(x, ...) <- value

\S4method{fsrnbr}{COBRAPerformance}(x)

\S4method{fsrnbr}{COBRAPerformance,data.frame}(x) <- value

\S4method{fsrnbr}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information about the observed FSR and the 
number of features called positive for each method and each stratification 
level, at various s-value thresholds. If the object does not have an fsrnbr
slot (older versions of the class did not have this slot), an empty data
frame is returned for simplicity.}
}
\value{
The accessor function returns a data frame giving information about
  the observed FSR and the number of features called positive for each method
  and each stratification level, at various s-value thresholds.
}
\description{
Accessor and replacement functions for the \code{fsrnbr} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example_sval)

cobraperf <- calculate_performance(cobradata_example_sval, 
                                   cont_truth = "logFC", 
                                   aspects = "fsrnbr")
head(fsrnbr(cobraperf))
}
\author{
Charlotte Soneson
}
