% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_fpc}
\alias{plot_fpc}
\title{Plot FP curves}
\usage{
plot_fpc(
  cobraplot,
  title = "",
  stripsize = 15,
  titlecol = "black",
  maxnfdc = 500,
  linewidth = 1
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{title}{A character string giving the title of the plot.}

\item{stripsize}{A numeric value giving the size of the strip text, when the
results are stratified by an annotation.}

\item{titlecol}{A character string giving the color of the title.}

\item{maxnfdc}{A numeric value giving the largest N to consider.}

\item{linewidth}{The line width used for plotting}
}
\value{
A ggplot object
}
\description{
Plot false positive curves, indicating the number of false positives among
the top-ranked N variables, for varying values of N.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status", aspects = "fpc")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_fpc(cobraplot, maxnfdc = 750)
}
\author{
Charlotte Soneson
}
