% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_upset}
\alias{plot_upset}
\title{Create UpSet plots}
\usage{
plot_upset(
  cobraplot,
  stratum = NULL,
  nsets = NULL,
  nintersects = NULL,
  sets.bar.color = NULL,
  ...
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{stratum}{If results are stratified, the category to plot results for.
Can be numeric or categorical (the name of the category).}

\item{nsets}{The number of methods to include. By default, it is determined
automatically from the \code{cobraplot} object.}

\item{nintersects}{The number of set intersections to display. By default, it
is determined automatically from the \code{cobraplot} object.}

\item{sets.bar.color}{The colors to use for the bars in the UpSet plot. By
default, they are extracted from the \code{plotcolors} slot of the
\code{cobraplot} object.}

\item{...}{Additional arguments to \code{UpSetR::upset}.}
}
\value{
Nothing, displays a graph
}
\description{
Generate UpSet plots showing the overlaps among sets of significant feature
for a given adjusted p-value threshold (see \code{thr_venn} argument of
\code{calculate_performance}). Optionally, the truth can be included
as a "perfect" method. Note that if the results are stratified, only one 
category at a time can be displayed.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "overlap")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_upset(cobraplot)
plot_upset(cobraplot, order.by = "freq", decreasing = TRUE)

cobraperf <- calculate_performance(cobradata_example, 
                                   binary_truth = "status", 
                                   aspects = "overlap",
                                   splv = "expr_cat")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2", 
                                   incltruth = TRUE)
plot_upset(cobraplot, stratum = "[2.85e+00,1.45e+01)")
}
\references{
Lex and Gehlenborg (2014): Points of view: Sets and intersections. Nature
Methods 11, 779.

Lex et al (2014): UpSet: Visualization of intersecting sets. IEEE
Transactions on Visualization and Computer Graphics 20(12), 1983-1992.
}
\author{
Charlotte Soneson
}
