% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctModulesCorrelation.R
\name{fctModulesCorrelation}
\alias{fctModulesCorrelation}
\title{fctModulesCorrelation}
\usage{
fctModulesCorrelation(eigengenesList, clusterList, threshold = 0.5)
}
\arguments{
\item{eigengenesList}{List with the first principal component of each cluster.}

\item{clusterList}{list containing cluster_assignments matrix.}

\item{threshold}{A numeric value to filter correlations. Default is 0.5.}
}
\value{
Return the Top_correlations between Prot and metab eigengenes, graph of red, correlation plot.
}
\description{
Calculates correlations between omic modules.
}
\examples{
# Simulate eigengene matrices for two omics datasets
set.seed(123)
eig1 <- matrix(rnorm(50), nrow = 10, ncol = 5)
colnames(eig1) <- paste0("ME", 1:5)
eig2 <- matrix(rnorm(50), nrow = 10, ncol = 5)
colnames(eig2) <- paste0("ME", 1:5)

# Simulate cluster assignments for each omic
cluster1 <- data.frame(
  feature = paste0("F", 1:5),
  cluster = paste0("cluster_", 1:5),
  col = RColorBrewer::brewer.pal(5, "Set1"),
  stringsAsFactors = FALSE
)
cluster2 <- data.frame(
  feature = paste0("F", 6:10),
  cluster = paste0("cluster_", 6:10),
  col = RColorBrewer::brewer.pal(5, "Set2"),
  stringsAsFactors = FALSE
)

# Run the correlation function
result <- fctModulesCorrelation(
  eigengenesList = list(eig1, eig2),
  clusterList = list(cluster1, cluster2),
  threshold = 0.5
)

# View top correlations
head(result$Top_cor_Prot_metab)
}
