% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-LoadingPlot.R
\docType{class}
\name{LoadingPlot-class}
\alias{LoadingPlot-class}
\alias{LoadingPlot}
\title{Loading plot}
\value{
The \code{LoadingPlot(...)} constructor creates an instance of an
LoadingPlot class, where any slot and its value can be passed to
\code{...} as a named argument.
}
\description{
Contribution of single features in a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}
to the components of a target reduced dimension. The panel implements
\code{\link[miaViz:plotLoadings]{plotLoadings}} to generate the plot.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualisation:
\itemize{
\item \code{dimred}, a string specifying the dimred to visualize.
\item \code{layout}, a string specifying abundance layout (barplot or heatmap).
\item \code{ncomponents}, a number indicating the number of components to visualize.
\item \code{add.tree}, a logical indicating whether the tree should be shown.
}

In addition, this class inherits all slots from its parent class
\code{\link[iSEE:Panel-class]{Panel}}.
}

\examples{
# Import libraries
library(mia)
library(scater)

# Import TreeSE
data("Tengeler2020", package = "mia")
tse <- Tengeler2020

# Add relabundance assay
tse <- transformAssay(tse, method = "relabundance")

# Add reduced dimensions
tse <- runPCA(tse, assay.type = "relabundance")

# Store panel into object
panel <- LoadingPlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\author{
Giulio Benedetti
}
