% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\name{getPValuePattern}
\alias{getPValuePattern}
\alias{getLogFCPattern}
\alias{getAveAbPattern}
\alias{setPValuePattern}
\alias{setLogFCPattern}
\alias{setAveAbPattern}
\title{Global DE prefixes}
\usage{
getPValuePattern()

getLogFCPattern()

getAveAbPattern()

setPValuePattern(value)

setLogFCPattern(value)

setAveAbPattern(value)
}
\arguments{
\item{value}{A character vector containing the acceptable prefixes for each statistic.}
}
\value{
\code{getPValuePattern} returns the patterns for acceptable column names for p-values.

\code{getLogFCPattern} returns the patterns for acceptable column names for log-fold changes.

\code{getAveAbPattern} returns the patterns for acceptable column names for the average abundances.

The corresponding setters set the global parts for each statistic and return \code{NULL} invisibly.
}
\description{
Get or set patterns for acceptable names of \code{\link{rowData}} columns related to a differential expression analysis.
These functions are deprecated; use their counterparts in \code{?"\link{registerPValuePatterns}"} instead.
}
\details{
These utilities allow users to easily get and set the patterns of acceptable fields in all
\linkS4class{VolcanoPlot}s, \linkS4class{MAPlot}s and \linkS4class{LogFCLogFCPlot}s at once.
Any global settings only take effect (i) during setup of the \code{\link{iSEE}} application
and (ii) if the first panel of each class does not have existing values in the
\code{"PValueFields"}, \code{"LogFCFields"} or \code{"AveAbFields"} slots (which take precedence if present).

Each of these global settings are treated as \emph{patterns} for partial matching.
For the \code{"PValue"} pattern, columns with the names \code{"PValue.X"} and \code{"X.PValue"} will be considered acceptable matches.
All partial matching must be exact - regular expressions are not supported.
}
\examples{
old <- getPValuePattern()

setPValuePattern(LETTERS)
getPValuePattern()

setPValuePattern(old)
}
\seealso{
\linkS4class{VolcanoPlot}, \linkS4class{MAPlot} and \linkS4class{LogFCLogFCPlot},
which are affected by these globals.
}
\author{
Aaron Lun
}
