% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_markers.R
\name{find_markers}
\alias{find_markers}
\title{A function for finding markers for hidden factors}
\usage{
find_markers(Y, iasva.sv, method = "BH", sig.cutoff = 0.05,
  rsq.cutoff = 0.3, verbose = FALSE)
}
\arguments{
\item{Y}{A SummarizedExperiment class containing read counts where
rows represent genes and columns represent samples.}

\item{iasva.sv}{matrix of estimated surrogate variables,
one column for each surrogate variable.}

\item{method}{multiple testing adjustment method, default = "BH".}

\item{sig.cutoff}{significance cutoff.}

\item{rsq.cutoff}{R squared cutoff.}

\item{verbose}{If verbose = TRUE, the function outputs detailed messages.}
}
\value{
marker.counts read counts matrix of markers,
 one column for each cell.
}
\description{
Function takes a read counts matrix of entire gene set and a matrix
 of surrogate variables estimated by IA-SVA as input, 
 identifies marker genes highly correlated with each surrogate variable
 and returns a read counts matrix of the markers.
}
\examples{
counts_file <- system.file("extdata", "iasva_counts_test.Rds",
 package = "iasva")
counts <- readRDS(counts_file)
anns_file <- system.file("extdata", "iasva_anns_test.Rds",
 package = "iasva")
 anns <- readRDS(anns_file)
Geo_Lib_Size <- colSums(log(counts + 1))
Patient_ID <- anns$Patient_ID
mod <- model.matrix(~Patient_ID + Geo_Lib_Size)
summ_exp <- SummarizedExperiment::SummarizedExperiment(assays = counts)
iasva.res <- iasva(summ_exp, mod[, -1], num.sv = 5, permute = FALSE)
markers <- find_markers(summ_exp, iasva.res$sv)
}
