% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/detectDiffTSS.R
\name{fitDiffTSS}
\alias{fitDiffTSS}
\alias{fitDiffTSS,CapSet-method}
\title{Detect differentially expressed Transcription Start Sites between two conditions (fit model)}
\usage{
fitDiffTSS(
  CSobject,
  TSSfile = NULL,
  groups,
  method = "DESeq2",
  normalization = NULL,
  normFactors = NULL,
  outplots = NULL,
  plotRefSample = NA,
  ncores = 1
)

\S4method{fitDiffTSS}{CapSet}(
  CSobject,
  TSSfile = NULL,
  groups,
  method = "DESeq2",
  normalization = NULL,
  normFactors = NULL,
  outplots = NULL,
  plotRefSample = NA,
  ncores = 1
)
}
\arguments{
\item{CSobject}{An object of class \code{\link{CapSet}}}

\item{TSSfile}{A .bed file with TSS positions to test for differential TSS analysis. If left
empty, the union of detected TSS present within the provided CSobject would be plotted.}

\item{groups}{Character vector indicating the group into which each sample within the CSobject falls.
the groups would be use to create a design matrix. As an example, replicates for one
condition could be in the same group.}

\item{method}{Which method to use for differential expression analysis? options are "DESeq2" or "edgeR".
If "DESeq2" is chosen, the library size is either estimated via DESeq2 (using "median of ratios")
or can be provided via the "normFactors" option below. Setting the "normalization"
(below) has no effect in that case.}

\item{normalization}{A character indicating the type of normalization to perform. Options are "windowTMM",
"TMM", "RLE", "upperquartile" or NULL (don't compute normalization factors).
If "windowTMM" is chosen, the normalization factors are calculated using the TMM
method on 10 kb windows of the genome. "TMM" computes TMM normalization using counts
from all the evaluated TSSs. If NULL, the external normalization factors can be used
 (provided using `normFactors`).}

\item{normFactors}{external normalization factors (from Spike-Ins, for example).}

\item{outplots}{Output pdf filename for plots. If provided, the plots for BCV, dispersion and
MDS plot is created and saved in this file.}

\item{plotRefSample}{Name of reference sample to plot for detection of composition bias in the
data. Samples could be normalized using one of the provided normalization methods to
control for composition bias.}

\item{ncores}{No. of cores/threads to use}
}
\value{
An object of class \link[edgeR]{DGEGLM-class} or
        \link[DESeq2]{DESeqDataSet}
}
\description{
Detect differentially expressed Transcription Start Sites between two conditions (fit model)
}
\examples{
# before running this
# 1. Create a CapSet object
# 2. de-multiplex the fastqs
# 3. map them
# 4. filter duplicate reads from mapped BAM
# 5. detect TSS
# 6. fit the diffTSS model
\dontrun{
# load a previously saved CapSet object
cs <- exampleCSobject()

# count reads on all TSS (union) and fit a model using replicates within groups
csfit <- fitDiffTSS(cs, groups = rep(c("wt","mut"), each = 2), normalization = "internal",
                     outplots = NULL, plotRefSample = "embryo1")
save(csfit, file = "diffTSS_fit.Rdata")
}

}
