% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{calculate_midpoint_distance1d}
\alias{calculate_midpoint_distance1d}
\title{Distance between Midpoints of two Peaks}
\usage{
calculate_midpoint_distance1d(peak1_start, peak1_end, peak2_start, peak2_end)
}
\arguments{
\item{peak1_start}{integer vector; genomic start coordinate(s)
of peak in replicate 1}

\item{peak1_end}{integer vector; genomic end coordinate(s)
of peak in replicate 1}

\item{peak2_start}{integer vector; genomic start coordinate(s)
of peak in replicate 2}

\item{peak2_end}{integer vector; genomic end coordinate(s)
of peak in replicate 2}
}
\value{
positive integer vector; distances between peak pairs
}
\description{
Calculates the distance in nucleotides between the midpoints of
two peaks.

Note: peaks must be on the same
chromosome; start coordinate is always less than end coordinate
}
\examples{
# identical, zero distance
calculate_midpoint_distance1d(100, 120,
                          100, 120)

# centered, zero distance
calculate_midpoint_distance1d(100, 120,
                          90, 130)

# off by 10 per anchor
calculate_midpoint_distance1d(100, 120,
                         110, 130)

# vectorized example
calculate_midpoint_distance1d(c(100, 100, 100),
                          c(120, 120, 120),
                          c(100, 90, 110),
                          c(120, 130, 130))

}
