% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hic.R
\name{estimate_idr2d_hic}
\alias{estimate_idr2d_hic}
\title{Estimates IDR for Genomic Interactions measured by Hi-C experiments}
\usage{
estimate_idr2d_hic(
  rep1_df,
  rep2_df,
  combined_min_value = 30,
  combined_max_value = Inf,
  min_value = -Inf,
  max_value = Inf,
  max_factor = 1.5,
  jitter_factor = 1e-04,
  mu = 0.1,
  sigma = 1,
  rho = 0.2,
  p = 0.5,
  eps = 0.001,
  max_iteration = 30,
  local_idr = TRUE
)
}
\arguments{
\item{rep1_df}{data frame of either parsed .hic file from Juicer (output of
\code{\link{parse_juicer_matrix}}) or
parsed .matrix and .bed files from HiC-Pro (output of
\code{\link{parse_hic_pro_matrix}}) for replicate 1}

\item{rep2_df}{data frame of either parsed .hic file from Juicer (output of
\code{\link{parse_juicer_matrix}}) or
parsed .matrix and .bed files from HiC-Pro (output of
\code{\link{parse_hic_pro_matrix}}) for replicate 2}

\item{combined_min_value}{exclude blocks with a combined (replicate 1 +
replicate 2) read count or normalized read count of less than
 \code{combined_min_value} (default is 20 reads, set
 \code{combined_min_value = -Inf} to disable)}

\item{combined_max_value}{exclude blocks with a combined (replicate 1 +
replicate 2) read count or normalized read count of more than
 \code{combined_max_value} (disabled by default, set
 \code{combined_max_value = Inf} to disable)}

\item{min_value}{exclude blocks with a read count or normalized read count
of less than \code{min_value} in one replicate (disabled by default, set
 \code{min_value = -Inf} to disable)}

\item{max_value}{exclude blocks with a read count or normalized read count
of more than \code{max_value} in one replicate (disabled by default, set
 \code{max_value = Inf} to disable)}

\item{max_factor}{numeric; controls the replacement values for \code{Inf}
and \code{-Inf}. \code{Inf} are replaced by \code{max(x) * max_factor} and
\code{-Inf} are replaced by \code{min(x) / max_factor}.}

\item{jitter_factor}{numeric; controls the magnitude of the noise that
is added to \code{x}. This is done to break ties in \code{x}. Set
\code{jitter_factor = NULL} for no jitter.}

\item{mu}{ a starting value for the mean of the reproducible component.}

\item{sigma}{ a starting value for the standard deviation of the
    reproducible component.}

\item{rho}{ a starting value for the correlation coefficient of the
    reproducible component.}

\item{p}{ a starting value for the proportion of reproducible component.}

\item{eps}{ Stopping criterion. Iterations stop when the increment of
    log-likelihood is < eps*log-likelihood, Default=0.001.}

\item{max_iteration}{integer; maximum number of iterations for
IDR estimation (defaults to 30)}

\item{local_idr}{see \code{\link[idr:est.IDR]{est.IDR}}}
}
\value{
Data frame with the following columns:
\tabular{rll}{
  column 1: \tab \code{interaction} \tab character; genomic location of
  interaction block (e.g., \code{"chr1:204940000-204940000"})\cr
  column 2: \tab \code{value} \tab numeric; p-value, FDR, or heuristic used
  to rank the interactions\cr
  column 3: \tab \code{"rep_value"} \tab numeric; value of corresponding
  replicate interaction\cr
  column 4: \tab \code{"rank"} \tab integer; rank of the interaction,
  established by value column, ascending order\cr
  column 5: \tab \code{"rep_rank"} \tab integer; rank of corresponding
  replicate interaction\cr
  column 6: \tab \code{"idr"} \tab integer; IDR of the block and the
  corresponding block in the other replicate
}
}
\description{
This method estimates Irreproducible Discovery Rates (IDR) of
genomic interactions between two replicates of Hi-C experiments.

Before calling this method, call Juicer .hic contact matrix c

The contact matrix is subdivided into blocks, where the block size is
determined by \code{resolution}. The reads per block are used to rank blocks
and replicate blocks are easily matched by genomic location.
}
\examples{
idr_results_df <- estimate_idr2d_hic(idr2d:::hic$rep1_df,
                                     idr2d:::hic$rep2_df)
summary(idr_results_df)

}
\references{
Q. Li, J. B. Brown, H. Huang and P. J. Bickel. (2011) Measuring
reproducibility of high-throughput experiments. Annals of Applied
Statistics, Vol. 5, No. 3, 1752-1779.
}
