% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCSCBedAnnotationTrack.R
\docType{class}
\name{UCSCBedAnnotationTrack-class}
\alias{UCSCBedAnnotationTrack-class}
\alias{.UCSCBedAnnotationTrack}
\alias{UCSCBedAnnotationTrack}
\title{Constructor for UCSCBedAnnotationTrack}
\usage{
UCSCBedAnnotationTrack(
  trackName,
  annotation,
  color = "darkGrey",
  displayMode = "SQUISHED",
  trackHeight = 50,
  expandedRowHeight = 30,
  squishedRowHeight = 15,
  maxRows = 500,
  searchable = FALSE,
  visibilityWindow = 1e+05
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{annotation}{A UCSCData object imported by \code{rtracklayer}}

\item{color}{A CSS color name (e.g., "red" or "#FF0000")}

\item{displayMode}{"COLLAPSED", "SQUISHED" or "EXPANDED".  Spelling and case must be precise.}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{expandedRowHeight}{Height of each row of features in "EXPANDED" mode.}

\item{squishedRowHeight}{Height of each row of features in "SQUISHED" mode, for compact viewing.}

\item{maxRows}{of features to display}

\item{searchable}{If TRUE, labels on annotation elements may be used in search}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}
}
\value{
A UCSCBedAnnotationTrack object
}
\description{
\code{UCSCBedAnnotationTrack} creates and \code{IGV} track for bed objects imported using \code{rtracklayer}
}
\details{
Detailed description goes here
}
\examples{

bed.filepath <- system.file(package = "rtracklayer", "tests", "test.bed")
gr.bed <- rtracklayer::import(bed.filepath)
track <- UCSCBedAnnotationTrack("UCSC bed", gr.bed,  color="blue", displayMode="SQUISHED")

if(interactive()){
    igv <- igvR()
    setGenome(igv, "hg38")
    setBrowserWindowTitle(igv, "UCSC bed10 demo")
    showGenomicRegion(igv, "chr7:127,469,879-127,476,276")
    displayTrack(igv, track)
    }

}
