% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{chao1_richness}
\alias{chao1_richness}
\title{Chao1 Richness Estimator}
\usage{
chao1_richness(cnt)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts (one entry per clone/
residue/OTU).  Zero counts are ignored.}
}
\value{
A single numeric value representing the estimated total number of
  species.
}
\description{
Calculates the Chao1 non-parametric estimator of species richness.
}
\details{
The bias-corrected formula is used:
\deqn{S_{chao1} = S_{obs} + \frac{F_1(F_1 - 1)}{2(F_2 + 1)}}
where *S*obs is the number of observed species, *F*1
is the count of singletons, and *F*2 is the count of doubletons.

If the conditions for the formula are not met (*F*1 <= 1 or
*F*2 = 0), the function returns the observed richness (*S*obs).
}
\examples{
# Sample with singletons and doubletons
counts <- c(rep(1, 10), rep(2, 5), 5, 8, 12)
chao1_richness(counts)

# Sample without doubletons returns observed richness
chao1_richness(c(rep(1, 5), 3, 4, 5))
}
\references{
Chao, A. (1984). *Nonparametric estimation of the number of classes in a
population*. Scandinavian Journal of Statistics, 11(4), 265-270.
}
