% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{exportCellRanger}
\alias{exportCellRanger}
\title{Export Reference Sequences to Cell Ranger VDJ Format}
\usage{
exportCellRanger(sequences, output_file, gene_type = NULL)
}
\arguments{
\item{sequences}{A \code{\link[Biostrings]{DNAStringSet}} object containing
immune receptor sequences. Sequence names must follow standard IG/TR gene
nomenclature (e.g., \code{"IGHV1-2*01"}). Can be obtained from
\code{\link{getIMGT}} or \code{\link{getOGRDB}}.}

\item{output_file}{Character string specifying the path to the output FASTA
file. The parent directory will be created if it does not exist.}

\item{gene_type}{Character string specifying the type of gene region. One of
\code{"V"}, \code{"D"}, \code{"J"}, or \code{"C"}. If \code{NULL} (default),
the function will attempt to infer the type from sequence names.}
}
\value{
Character string with the path to the created file, returned
  invisibly.
}
\description{
Exports a \code{\link[Biostrings]{DNAStringSet}} to FASTA format
suitable for creating a custom Cell Ranger VDJ reference. The function
generates a FASTA file with properly formatted headers for use with
\code{cellranger mkvdjref}.
}
\details{
Cell Ranger's \code{mkvdjref} command expects FASTA files with specific
header formats. This function creates a FASTA file that can be used as input
to build a custom VDJ reference.

\strong{Note:} For a complete Cell Ranger VDJ reference, you also need a GTF
file with gene annotations. This function only creates the FASTA component.

This function works with sequences from both \strong{IMGT} (via
\code{\link{getIMGT}}) and \strong{OGRDB} (via \code{\link{getOGRDB}}).
}
\examples{
# Create a small example DNAStringSet
seqs <- Biostrings::DNAStringSet(c(
  "ATGCGATCGATCGATCG",
  "ATGCGATCGATCG"
))
names(seqs) <- c("IGHV1-2*01", "IGHV1-3*01")

# Export to temporary file
output_file <- tempfile(fileext = ".fa")
exportCellRanger(seqs, output_file)

# View the result
cat(readLines(output_file), sep = "\n")

# Clean up
unlink(output_file)
}
\seealso{
\code{\link{getIMGT}}, \code{\link{getOGRDB}} for obtaining sequences

\code{\link{exportMiXCR}}, \code{\link{exportTRUST4}},
\code{\link{exportIgBLAST}} for other export formats

\url{https://www.10xgenomics.com/support/software/cell-ranger/latest/analysis/inputs/cr-5p-references}
for Cell Ranger documentation
}
