% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R, R/RcppExports.R
\name{set_log_level}
\alias{set_log_level}
\alias{get_log_level}
\title{Set and get logging level}
\usage{
set_log_level(level = "info")

get_log_level()
}
\arguments{
\item{level}{The logging verbosity level to use
\itemize{
\item \code{"info"}: the default that gives provides basic information about the
number of files and regions used in a function
\item \code{"debug"}: more verbose about row allocations, how many CpGs were found in
a region, filename parsing etc. This mode cannot be used on more than one
thread as R cannot output messages from multiple threads without crashing.
\item \code{"off"}: no logging
}}
}
\value{
\itemize{
\item \code{set_log_level()}: None; sets the log level to the provided level
\item \code{get_log_level()}: The current logging level as a string
}
}
\description{
Set and get logging level
}
\examples{
set_log_level("info")
get_log_level()
}
