% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{counts}
\alias{counts}
\alias{counts.IsomirDataSeq}
\alias{counts,IsomirDataSeq-method}
\alias{counts<-,IsomirDataSeq,matrix-method}
\title{Accessors for the count matrix of a IsomirDataSeq object.}
\usage{
counts.IsomirDataSeq(object, norm = FALSE)

\S4method{counts}{IsomirDataSeq}(object, norm = FALSE)

\S4method{counts}{IsomirDataSeq,matrix}(object) <- value
}
\arguments{
\item{object}{A \code{IsomirDataSeq} object.}

\item{norm}{Boolean, return log2-normalized counts.}

\item{value}{An integer matrix.}
}
\value{
\link[base:matrix]{base::matrix} with raw or normalized count data.
}
\description{
The counts slot holds the count data as a matrix of non-negative integer
count values, one row for each isomiR, and one
column for each sample. The normalized matrix
can be obtained by using the parameter \code{norm=TRUE}.
}
\examples{
data(mirData)
head(counts(mirData))
}
\author{
Lorena Pantano
}
