% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Koina-class.R
\docType{class}
\name{Koina-class}
\alias{Koina-class}
\alias{Koina}
\title{Koina client class}
\value{
an instance of the Koina class
}
\description{
Koina client class
}
\section{Fields}{

\describe{
\item{\code{model_name}}{character, e.g., \code{"Prosit_2019_intensity". See https://koina.wilhelmlab.org/docs for all available models}.}

\item{\code{url}}{url, default is set to \code{"koina.wilhelmlab.org"}.}

\item{\code{ssl}}{logical.}

\item{\code{disable_progress_bar}}{logical.}
}}

\section{Methods}{

\describe{
\item{\code{predict(
  input_data,
  pred_as_df = TRUE,
  filters = list(intensities = c(1e-04, 1))
)}}{      Predict using the defined model.

      Arguments:

      - input_data: Either a dataframe or a list of arrays. `names` must correspond to the inputs for the chosen model.

      - pred_as_df: Logical, indicating if the results should be returned as a dataframe (TRUE) or in the original format (FALSE).

      - filters: A list of vectors which is used to filter predictions. The key needs to equal the name of the predicted property, the first value is used as minimum the second as maximum. Ignored when `pred_as_df` == FALSE.


      Returns:

      Depending on `pred_as_df`, returns either a dataframe or a list/array of predictions, applying `min_intensity` filtering if applicable.
      }
}}

\examples{
library(koinar)
prosit2019 <- koinar::Koina(
  model_name = "Prosit_2019_intensity",
  server_url = "koina.wilhelmlab.org"
)

input <- data.frame(
  peptide_sequences = c("LGGNEQVTR", "GAGSSEPVTGLDAK"),
  collision_energies = c(25, 25),
  precursor_charges = c(1, 2)
)

# Fetch the predictions by calling `$predict` of the model you want to use
prediction_results <- prosit2019$predict(input)
}
\seealso{
\url{https://koina.wilhelmlab.org}
}
\author{
Ludwig Lautenbacher, 2024
}
