% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_on_fit.R
\name{project_on_lemur_fit}
\alias{project_on_lemur_fit}
\title{Project new data onto the latent spaces of an existing lemur fit}
\usage{
project_on_lemur_fit(
  fit,
  data,
  col_data = NULL,
  use_assay = "logcounts",
  design = fit$design,
  alignment_design = fit$alignment_design,
  return = c("matrix", "lemur_fit")
)
}
\arguments{
\item{fit}{an \code{lemur_fit} object}

\item{data}{a matrix with observations in the columns and features in the rows.
Or a \code{SummarizedExperiment} / \code{SingleCellExperiment} object. The features must
match the features in \code{fit}.}

\item{col_data}{col_data an optional data frame with \code{ncol(data)} rows.}

\item{use_assay}{if \code{data} is a \code{SummarizedExperiment} / \code{SingleCellExperiment} object,
which assay should be used.}

\item{design, alignment_design}{the design formulas or design matrices that are used
to project the data on the correct latent subspace. Both default to the designs
from the \code{fit} object.}

\item{return}{which data structure is returned.}
}
\value{
Either a matrix with the low-dimensional embeddings of the \code{data} or
an object of class \code{lemur_fit} wrapping that embedding.
}
\description{
Project new data onto the latent spaces of an existing lemur fit
}
\examples{

data(glioblastoma_example_data)

subset1 <- glioblastoma_example_data[,1:2500]
subset2 <- glioblastoma_example_data[,2501:5000]

fit <- lemur(subset1, design = ~ condition, n_emb = 5,
             test_fraction = 0, verbose = FALSE)

# Returns a `lemur_fit` object with the projection of `subset2`
fit2 <- project_on_lemur_fit(fit, subset2, return = "lemur_fit")
fit2



}
