% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data2lmpDataList.R
\name{data2LmpDataList}
\alias{data2LmpDataList}
\title{Converts data to a lmpDataList.}
\usage{
data2LmpDataList(
  se = NULL,
  assay_name = NULL,
  outcomes = NULL,
  design = NULL,
  formula = NULL,
  verbose = TRUE
)
}
\arguments{
\item{se}{A \code{\link[SummarizedExperiment]{SummarizedExperiment}} object.}

\item{assay_name}{If not \code{NULL} (default), a character string naming the assay from the \code{\link[SummarizedExperiment]{SummarizedExperiment}} object \code{se}. If \code{NULL}, the first assay is selected.}

\item{outcomes}{If not \code{NULL} (default), a numerical matrix with \emph{n} observations and \emph{m} response variables. The rownames needs to be non-NULL and match those of the design matrix.}

\item{design}{If not \code{NULL} (default), a data.frame with the experimental design of \emph{n} observations and \emph{q} explanatory variables. The rownames of design has to match the rownames of outcomes.}

\item{formula}{If not \code{NULL} (default), a character string with the formula that will be used to analyze the data. Only the right part of the formula is necessary, eg: \code{"~ A + B"}, The names of the formula should match the column names of the design}

\item{verbose}{If \code{TRUE}, prints useful information about the outputted list.}
}
\value{
A list with the 3 following named elements:
\describe{
\item{\code{outcomes}}{A \emph{nxm} matrix with the \emph{m} response variables.}
\item{\code{design}}{A \emph{nxq} data.frame with the experimental design.}
\item{\code{formula}}{A character string with the model formula.}
}
}
\description{
Creates the lmpDataList from a SummarizedExperiment or by manually defining the design, the outcomes and the model formula.
lmpDataList serves as an input for the \code{\link{lmpModelMatrix}} function to start the limpca modeling.
}
\details{
Data can be included as a \code{\link[SummarizedExperiment]{SummarizedExperiment}} (SE) object or by manually defining one or multiple
elements of \code{outcomes}, \code{design} and \code{formula}. If a SE is provided,
the \code{outcomes} corresponds to a transposed assay of the SE (by default the first one),
the \code{design} corresponds to the \code{\link[SummarizedExperiment]{colData}} of the SE and the \code{formula} can be provided as a
\code{formula} element in the \code{S4Vectors::metadata} of SE (\code{metadata(se)$formula}).

In the outputted list, the outcomes are structured in a standard statistical fashion,
i.e. with observations in rows and the variables (features) in column.
If the \code{outcomes} argument is not \code{NULL}, it has to be formatted that way (see Arguments).

Note that there is a priority to the \code{outcomes}, \code{design} and \code{formula}
arguments if they are not \code{NULL} (e.g. if both \code{se} and \code{outcomes} arguments are provided,
the resulting outcomes matrix will be from the \code{outcomes} argument). \code{outcomes} and \code{design} elements are mandatory.

Multiple checks are performed to ensure that the data are correctly formatted:
\itemize{
\item the rownames of \code{design} and \code{outcomes} should match
\item the names of the model terms in the \code{formula} should match column names from the \code{design}
}
}
\examples{

data(UCH)

### create manually the dataset

res <- data2LmpDataList(
  outcomes = UCH$outcomes,
  design = UCH$design[, 1, drop = FALSE], formula = "~ Hippurate"
)

### create the dataset from a SummarizedExperiment

library(SummarizedExperiment)

se <- SummarizedExperiment(
  assays = list(
    counts = t(UCH$outcomes),
    counts2 = t(UCH$outcomes * 2)
  ), colData = UCH$design,
  metadata = list(formula = "~ Hippurate + Citrate")
)

res <- data2LmpDataList(se, assay_name = "counts2")

# changing the formula:
res <- data2LmpDataList(se,
  assay_name = "counts2",
  formula = "~ Hippurate + Citrate + Time"
)

}
\seealso{
\code{\link[SummarizedExperiment]{SummarizedExperiment}}
}
