% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaScorePlot.R
\name{pcaScorePlot}
\alias{pcaScorePlot}
\title{Score plots}
\usage{
pcaScorePlot(
  resPcaBySvd,
  design = NULL,
  axes = c(1, 2),
  title = "PCA score plot",
  points_labs_rn = FALSE,
  ...
)
}
\arguments{
\item{resPcaBySvd}{A list corresponding to the output value of \code{\link{pcaBySvd}}.}

\item{design}{A \eqn{n \times k} "freely encoded" experimental design data.frame.}

\item{axes}{A numerical vector of length 2 with the Principal Components axes to be drawn.}

\item{title}{Plot title.}

\item{points_labs_rn}{Boolean indicating if the rownames of the scores matrix should be plotted.}

\item{...}{Additional arguments to be passed to \code{\link{plotScatter}}.}
}
\value{
A \code{ggplot2} PCA score plot.
}
\description{
Produces score plots from \code{\link{pcaBySvd}} output with the same graphical options as \code{\link{plotScatter}} as this is a wrapper of this function..
}
\details{
\code{pcaScorePlot} is a wrapper of \code{\link{plotScatter}}. See \code{?plotScatter} for more information on the additional arguments.
}
\examples{

data("UCH")

# design is explicitly defined
ResPCA <- pcaBySvd(Y = UCH$outcomes)

pcaScorePlot(
  resPcaBySvd = ResPCA, axes = c(1, 2),
  title = "PCA score plot UCH", design = UCH$design,
  color = "Hippurate", shape = "Citrate"
)

# design is recovered from lmpDataList through pcaBySvd()
ResPCA <- pcaBySvd(lmpDataList = UCH)

pcaScorePlot(
  resPcaBySvd = ResPCA, axes = c(1, 2),
  title = "PCA score plot UCH",
  color = "Hippurate", shape = "Citrate"
)

}
