% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/allGenerics.R, R/allAccessor.R
\docType{class}
\name{geneSet-class}
\alias{geneSet-class}
\alias{geneSet}
\alias{numGene}
\alias{description}
\alias{geneSetList}
\alias{numGene,geneSet-method}
\alias{description,geneSet-method}
\alias{geneSetList,geneSet-method}
\title{geneSet Class}
\usage{
numGene(x)

description(x)

geneSetList(x)

\S4method{numGene}{geneSet}(x)

\S4method{description}{geneSet}(x)

\S4method{geneSetList}{geneSet}(x)
}
\arguments{
\item{x}{An geneSet object}
}
\value{
Object of class geneSet
}
\description{
geneSet Class contains information for names of gene sets and a list of 
gene sets
}
\section{Slots}{

\describe{
\item{\code{numGene}}{numeric; the total number of all genes;
This number is used in enrichment tests}

\item{\code{description}}{vector of character; additional information for gene 
sets, such as names, URLs, a short description, etc.}

\item{\code{geneSetList}}{list;  a list of gene sets; each member is a 
vector containing a group of gene identifiers}
}}

\examples{
biocarta.link.file <- system.file("extdata", 
    "geneSet/biocarta.txt", package="loci2path")
biocarta.link <- read.delim(biocarta.link.file, header=FALSE, 
    stringsAsFactors=FALSE)
biocarta.set.file <- system.file("extdata", "geneSet/biocarta.set.txt", 
    package="loci2path")
set.geneid <- read.table(biocarta.set.file, stringsAsFactors=FALSE)
set.geneid <- strsplit(set.geneid[,1], split=",")
names(set.geneid) <- biocarta.link[,1]
biocarta <- geneSet(
    geneSetList=set.geneid,
    description=biocarta.link[,2],
    numGene=31847)
numGene(biocarta)
head(description(biocarta))
head(geneSetList(biocarta))
}
