% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugInteractions.R
\name{drugInteractions}
\alias{drugInteractions}
\title{Drug-Gene Interactions}
\usage{
drugInteractions(
  maf,
  top = 20,
  genes = NULL,
  plotType = "bar",
  drugs = FALSE,
  fontSize = 0.8
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{top}{Top number genes to check for. Default 20}

\item{genes}{Manually specify gene list}

\item{plotType}{Can be bar, pie Default bar plot.}

\item{drugs}{Check for known/reported drugs. Default FALSE}

\item{fontSize}{Default 0.8}
}
\description{
Checks for drug-gene interactions and druggable categories
}
\details{
This function takes a list of genes and checks for known/reported drug-gene interactions or Druggable categories.
All gene-drug interactions and drug claims are compiled from Drug Gene Interaction Databse. See reference for details and cite it if you use this function.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
drugInteractions(maf = laml)
}
\references{
Griffith, M., Griffith, O. L., Coffman, A. C., Weible, J. V., McMichael, J. F., Spies, N. C., et. al,. 2013. DGIdb - Mining the druggable genome. Nature Methods.
}
