% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSignatures.R
\name{estimateSignatures}
\alias{estimateSignatures}
\title{Estimate number of signatures based on cophenetic correlation metric}
\usage{
estimateSignatures(
  mat,
  nMin = 2,
  nTry = 6,
  nrun = 10,
  parallel = 4,
  pConstant = NULL,
  verbose = TRUE,
  plotBestFitRes = FALSE
)
}
\arguments{
\item{mat}{Input matrix of diemnsion nx96 generated by \code{\link{trinucleotideMatrix}}}

\item{nMin}{Minimum number of signatures to try. Default 2.}

\item{nTry}{Maximum number of signatures to try. Default 6.}

\item{nrun}{numeric giving the number of run to perform for each value in range. Default 5}

\item{parallel}{Default 4. Number of cores to use.}

\item{pConstant}{A small positive value to add to the matrix. Use it ONLY if the functions throws an \code{non-conformable arrays} error}

\item{verbose}{Default TRUE}

\item{plotBestFitRes}{plots consensus heatmap for range of values tried. Default FALSE}
}
\value{
a list with \code{NMF.rank} object and summary stats.
}
\description{
Estimate number of signatures based on cophenetic correlation metric
}
\details{
This function decomposes a non-negative matrix into n signatures.
Extracted signatures are compared against 30 experimentally validated signatures by calculating cosine similarity. See http://cancer.sanger.ac.uk/cosmic/signatures for details.
}
\examples{
\dontrun{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
laml.tnm <- trinucleotideMatrix(maf = laml, ref_genome = 'BSgenome.Hsapiens.UCSC.hg19', prefix = 'chr',
add = TRUE, useSyn = TRUE)
library("NMF")
laml.sign <- estimateSignatures(mat = laml.tnm, plotBestFitRes = FALSE, nMin = 2, nTry = 3, nrun = 2, pConstant = 0.01)
}
}
\seealso{
\code{\link{plotCophenetic}} \code{\link{extractSignatures}} \code{\link{trinucleotideMatrix}}
}
