% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maf_methods.R
\name{getSampleSummary}
\alias{getSampleSummary}
\alias{getSampleSummary,MAF-method}
\alias{getSampleSummary,GISTIC-method}
\title{extract sample summary from MAF or GISTIC object}
\usage{
getSampleSummary(x)

\S4method{getSampleSummary}{MAF}(x)

\S4method{getSampleSummary}{GISTIC}(x)
}
\arguments{
\item{x}{An object of class MAF or GISTIC}
}
\value{
sample summary table
}
\description{
extract sample summary from MAF or GISTIC object
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
getSampleSummary(x = laml)
}
