% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vafComapre.R
\name{vafCompare}
\alias{vafCompare}
\title{compare VAF across two cohorts}
\usage{
vafCompare(
  m1,
  m2,
  genes = NULL,
  top = 5,
  vafCol1 = NULL,
  vafCol2 = NULL,
  m1Name = "M1",
  m2Name = "M2",
  cols = c("#2196F3", "#4CAF50"),
  sigvals = TRUE,
  nrows = NULL,
  ncols = NULL
)
}
\arguments{
\item{m1}{first \code{\link{MAF}} object. Required.}

\item{m2}{second \code{\link{MAF}} object. Required.}

\item{genes}{specify genes for which plot has to be generated. Default NULL.}

\item{top}{if \code{genes} is NULL plots top n number of genes. Defaults to 5.}

\item{vafCol1}{manually specify column name for vafs in \code{m1}. Default looks for column 't_vaf'}

\item{vafCol2}{manually specify column name for vafs in \code{m2}. Default looks for column 't_vaf'}

\item{m1Name}{optional name for first cohort}

\item{m2Name}{optional name for second cohort}

\item{cols}{vector of colors corresponding to \code{m1} and \code{m2} respectivelly.}

\item{sigvals}{Estimate and add significance stars. Default TRUE.}

\item{nrows}{Number of rows in the layout. Default NULL - estimated automatically}

\item{ncols}{Number of genes drawn per row. Default 4}
}
\description{
Draw boxplot distibution of VAFs across two cohorts
}
