% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls.R
\name{generate_nulls}
\alias{generate_nulls}
\title{Generate null distributions of motif counts for each motif type}
\usage{
generate_nulls(
  edgelist = NULL,
  paralogs = NULL,
  edgelist_ppi = NULL,
  n = 1000,
  bp_param = BiocParallel::SerialParam()
)
}
\arguments{
\item{edgelist}{A 2-column data frame with regulators in column 1 and
targets in column 2.}

\item{paralogs}{A 2-column data frame with gene IDs for each paralog
in the paralog pair.}

\item{edgelist_ppi}{A 2-column data frame with IDs of genes that encode
each protein in the interacting pair.}

\item{n}{Number of degree-preserving simulated networks to generate.
Default: 1000.}

\item{bp_param}{BiocParallel back-end to be used.
Default: BiocParallel::SerialParam().}
}
\value{
A list of numeric vectors named \code{lambda}, \code{delta}, \code{V},
\code{PPI_V}, and \code{bifan}, containing the null distribution of motif counts
for each motif type.
}
\description{
Generate null distributions of motif counts for each motif type
}
\examples{
set.seed(123)
data(gma_grn)
data(gma_paralogs)
data(gma_ppi)
edgelist <- gma_grn[500:1000, 1:2] # reducing for test purposes
paralogs <- gma_paralogs[gma_paralogs$type == "WGD", 1:2]
edgelist_ppi <- gma_ppi
n <- 2 # small n for demonstration purposes
generate_nulls(edgelist, paralogs, edgelist_ppi, n)
}
