% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-CountMatrix.R
\docType{class}
\name{CountMatrix-class}
\alias{CountMatrix-class}
\alias{CountMatrix}
\alias{show,CountMatrix-method}
\title{CountMatrix Class}
\usage{
\S4method{show}{CountMatrix}(object)
}
\arguments{
\item{object}{A CountMatrix object.}
}
\value{
A CountMatrix object (clone of DelayedArray)

A DelayedArray object with dimnames
 for the first two dimensions.
}
\description{
A class for displaying dimnames associated
with the count matrices resulting from
pullHicMatrices() |> counts(showDimnames=TRUE).
}
\details{
This class is used only for attaching
a "show" method.
}
\section{Slots}{

\describe{
\item{\code{object}}{InteractionArray object}
}}

\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Read in loop pixels as GInteractions object
pixels <-
    WT_5kbLoops.txt() |>
    setNames("WT") |>
    read.table(header=TRUE) |>
    as_ginteractions(keep.extra.columns=FALSE) |>
    assignToBins(binSize=100e3)

## Removes the "chr" prefix for compatibility
## with the preprocessed hic files
GenomeInfoDb::seqlevelsStyle(pixels) <- 'ENSEMBL'

## Expand pixels to regions for pulling
## Hi-C submatrices
regions <- pixelsToMatrices(x=pixels, buffer=5)

## Extract 11x11 count matrices from the
## first 100 regions and 2 Hi-C files
iarr <- pullHicMatrices(x=regions[1:100],
                        files=hicFiles,
                        binSize=100e3)

## Display the start bin of each
## interaction in the count
## matrices
counts(iarr, showDimnames=TRUE)
}
\keyword{internal}
