% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-JaggedArray.R
\docType{class}
\name{JaggedArray-class}
\alias{JaggedArray-class}
\alias{JaggedArray}
\alias{show,JaggedArray-method}
\alias{[,JaggedArray,ANY,ANY,ANY-method}
\alias{as.list,JaggedArray-method}
\alias{path,JaggedArray-method}
\alias{dim,JaggedArray-method}
\title{JaggedArray Class}
\usage{
\S4method{show}{JaggedArray}(object)

\S4method{[}{JaggedArray,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{as.list}{JaggedArray}(x)

\S4method{path}{JaggedArray}(object)

\S4method{dim}{JaggedArray}(x)
}
\arguments{
\item{object}{JaggedArray object.}

\item{x}{JaggedArray object.}

\item{i}{Numeric vector indicating the indices
of interactions to extract.}

\item{j}{Numeric vector indicating the indices
of files to extract.}

\item{...}{Additional indices for subsetting
multidimensional arrays.}

\item{drop}{Not accepted for JaggedArray objects.}
}
\value{
`JaggedArray()` creates a JaggedArray
 object.

Subsetting returns a JaggedArray or DelayedArray object
 (see Details).

`as.list()` returns a list of matrices.

`path()` returns a character vector with the path to
 the HDF5 file with the JaggedArray data.

`dim()` returns a list of dimensions
 of the JaggedArray of rows, cols, interactions
 and files.
}
\description{
The `JaggedArray` class creates
a container for storing irregular or
jagged array data. This allows the
storage of matrices with different
dimensions on-disk using HDF5.

Subset a JaggedArray by its interactions
([i,]) or its Hi-C files ([,j]).

`as.list` reads the on-disk data and returns it
as an in-memory list of matrices.
}
\details{
NOTE: This class is designed specifically
for holding a 4-dimensional JaggedArray
<n x m x i x j> where n x m are rows and
cols of count matrices, i is interactions,
and j is Hi-C files.

The object returned will be a JaggedArray
if the submatrices contain different dimensions.
However, the returned object will automatically
be coerced into a DelayedArray if possible (i.e.
the dimensions of the rows and columns are the same.)

The JaggedArray data is still stored on-disk in
an HDF5 file until it is coerced into a DelayedArray
or realized as a list of matrices.
}
\section{Slots}{

\describe{
\item{\code{h5File}}{path to file for creating
and storing data as an HDF5 file.}

\item{\code{dim}}{dimensions describing the
number of matrices contained. dim[1]
is the number of interactions, dim[2]
is the number of files.}

\item{\code{subList}}{is a list of length 2
where the first position refers to
interactions and the second refers to
files. This list is used to record
subsetting operations which are then
later applied when accessing data
stored in the HDF5 file.}
}}

\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Create test interactions
gi <- read.table(text="
            1 51000000 51300000 1 51000000 51500000
            2 52000000 52300000 3 52000000 52500000
            1 150000000 150500000 1 150000000 150300000
            2 52000000 52300000 2 52000000 52800000") |>
    as_ginteractions()

## InteractionJaggedArray object
iarr <- pullHicMatrices(gi, hicFiles, 100e03, half="both")
arr <- counts(iarr)
arr

## Subsetting
arr[,,1,] # DelayedArray
arr[,,,1] # JaggedArray

## Realize as list
as.list(arr)

## Find the data path
path(arr)

## Find the data path
dim(arr)

}
