% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-pixelsToMatrices.R
\name{pixelsToMatrices}
\alias{pixelsToMatrices}
\alias{pixelsToMatrices,GInteractions,numeric-method}
\title{Expand pixels to submatrices}
\usage{
pixelsToMatrices(x, buffer)

\S4method{pixelsToMatrices}{GInteractions,numeric}(x, buffer)
}
\arguments{
\item{x}{GInteractions object.}

\item{buffer}{Number (length one numeric vector)
of pixels around the pixels in `x`.}
}
\value{
`x` with updated ranges.
}
\description{
Pixels are defined as paired-ranges with
starts & ends equal to their `binSize`.
This function takes GInteractions fitting
this description and expands the ranges
such that there is a `buffer` of pixels
around each range.
}
\details{
For example, a buffer of 3 would return a
GInteractions object with 3 pixels surrounding
the original pixel ranges.

After using `pullHicMatrices()`, the result will
return a matrix of row and column dimensions of
buffer*2+1.

Note, this function does not handle out-of-bound
ranges.
}
\examples{
## Define example 100bp pixel
library(InteractionSet)
pixel <- GInteractions(
    anchor1=GRanges("chr1:500-600"),
    anchor2=GRanges("chr1:2000-2100")
)

## Expand pixel to matrix with
## 3 pixels surrounding the center
## pixel
region <- pixelsToMatrices(x=pixel, buffer=3)
region

}
