% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-removeShortPairs.R
\name{removeShortPairs}
\alias{removeShortPairs}
\alias{removeShortPairs,GInteractions-method}
\title{Remove interactions that would cross
the Hi-C diagonal or a specified
distance from the diagonal.}
\usage{
removeShortPairs(x, padding = 0)

\S4method{removeShortPairs}{GInteractions}(x, padding = 0)
}
\arguments{
\item{x}{A GInteractions object.}

\item{padding}{Minimum distance away
from the diagonal.}
}
\value{
A GInteractions object with
 the short pairs removed.
}
\description{
Removes short interactions with some
padding from the diagonal. If you are
resizing the regions with a function
like `pixelsToMatrices()`, make sure
this function is run afterwards.
}
\details{
Note this is only applies to
intrachromosomal pairs, as pair distance
is meaningless for interchromosomal
pairs. Therefore, all interchromosomal
pairs are kept.
}
\examples{
## Example GInteractions object
gi <- as_ginteractions(read.table(
    text="
        seqnames1 start1 end1 seqnames2 start2 end2 keep
        chr1 300 400 chr1 300 400 'no'
        chr1 100 200 chr1 300 400 'yes'
        chr1 300 400 chr1 100 200 'yes'
        chr1 300 400 chr2 300 400 'yes'
        chr1 250 350 chr1 300 400 'only_with_padding_50'
        chr1 300 400 chr1 250 350 'only_with_padding_50'
        ",
    header=TRUE
))

## Remove pairs that would cross the diagonal
removeShortPairs(gi)

## Add 50bp of padding
removeShortPairs(gi, padding=50)

}
