% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scones.R
\name{mincut.cv}
\alias{mincut.cv}
\title{Run the cross-validated min-cut algorithm}
\usage{
mincut.cv(
  gwas,
  net,
  covars,
  etas,
  lambdas,
  criterion,
  score,
  sigmod,
  family,
  link,
  max_prop_snp
)
}
\arguments{
\item{gwas}{A SnpMatrix object with the GWAS information.}

\item{net}{An igraph network that connects the SNPs.}

\item{covars}{A data frame with the covariates. It must contain a column 
'sample' containing the sample IDs, and an additional columns for each 
covariate.}

\item{family}{A string defining the generalized linear model family. This 
should match one of "binomial", "poisson", "gaussian" or "gamma". See
\link[snpStats]{snp.rhs.tests} for details.}

\item{link}{A string defining the link function for the GLM. This should
match one of "logit", "log", "identity" or "inverse". See 
\link[snpStats]{snp.rhs.tests} for details.}
}
\description{
Run the cross-validated min-cut algorithm
}
\keyword{internal}
