% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappingEvents.R
\name{mapTranscriptsToEvents}
\alias{mapTranscriptsToEvents}
\title{Mapping of splice events to Ensembl transcripts.}
\usage{
mapTranscriptsToEvents(events, gtf, ncores = 1)
}
\arguments{
\item{events}{a maser object.}

\item{gtf}{a \code{GRanges} object obtained from an Ensembl or Gencode GTF
file using the hg38 build of the human genome.}

\item{ncores}{number of cores for multithreading (available only in OSX and Linux 
machines). If Windows, \code{ncores} will be set to 1 automatically.}
}
\value{
a maser object with transcript and protein identifiers.
}
\description{
Mapping of splice events to Ensembl transcripts.
}
\details{
This function performs mapping of splice events in the maser object
 to Ensembl transcripts by overlapping exons involved in the splice event to
 the transcript models provided in the GTF. 
 
 Each type of splice event requires a specific mapping procedure
  (described below).
 
 The mapping will also add Uniprot identifiers when the ENST transcript 
 encodes for a protein. 
   
 Visualization of affected transcripts can be done 
 using \code{\link{plotTranscripts}}.
 
  \describe{
    \item{\strong{Exon skipping}}{}
    \item{Inclusion transcript(s)}{Transcript(s) overlapping the cassette
     exon, as well both flanking exons (i.e upstream and downstream exons).}
    \item{Skipping transcript(s)}{Transcript(s) overlapping both flanking 
    exons but not the cassettte exon.}
  }
  
  \describe{
    \item{\strong{Intron retention}}{}
    \item{Retention transcript(s)}{Transcript(s) overlapping exactly the
     retained intron.}
    \item{Skipping transcript(s)}{Transcript(s) where intron is spliced out
     and overlapping both flanking exons.}
  }
  
  \describe{
  \item{\strong{Mutually exclusive exons}}{}
    \item{Exon1 transcript(s)}{Transcript(s) overlapping the first exon 
    and both flanking exons.}
    \item{Exon2 transcript(s)}{Transcript(s) overlapping the second exon and
     both flanking exons.}
  }
  
  \describe{
    \item{\strong{Alternative 3' and 5' splice sites}}{}
    \item{Short exon transcript(s)}{Transcript(s) overlapping both short and 
                       downstream exons.}
    \item{Long exon transcript(s)}{Transcript(s) overlapping both long and
     downstream exons.}
  }
}
\examples{
## Create the maser object
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)

## Ensembl GTF annotation for SRSF6
gtf_path <- system.file("extdata", file.path("GTF", 
 "Ensembl85_examples.gtf.gz"), package = "maser")
ens_gtf <- rtracklayer::import.gff(gtf_path)
 
## Retrieve gene specific splice events
srsf6_events <- geneEvents(hypoxia_filt, geneS = "SRSF6")

## Map splicing events to transcripts
srsf6_mapped <- mapTranscriptsToEvents(srsf6_events, ens_gtf)
head(annotation(srsf6_mapped, "SE"))

}
\seealso{
\code{\link{plotTranscripts}}
}
