% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEvents.R
\name{splicingDistribution}
\alias{splicingDistribution}
\title{Proportion of events by splicing type.}
\usage{
splicingDistribution(events, fdr = 0.05, deltaPSI = 0.1)
}
\arguments{
\item{events}{a maser object.}

\item{fdr}{numeric, FDR (False Discovery Rate) cutoff.}

\item{deltaPSI}{numeric, absolute minimum PSI (Percent spliced-in) change}
}
\value{
a ggplot object.
}
\description{
Proportion of events by splicing type.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)
splicingDistribution(hypoxia_filt)
}
