% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/remove_bg_exp-methods.R
\name{remove_bg_exp}
\alias{remove_bg_exp}
\alias{remove_bg_exp,matrix,matrix,vector-method}
\alias{remove_bg_exp,DGEList,matrix,vector-method}
\alias{remove_bg_exp,ANY,DGEList,vector-method}
\alias{remove_bg_exp,ANY,ExpressionSet,vector-method}
\alias{remove_bg_exp,ANY,SummarizedExperiment,vector-method}
\alias{remove_bg_exp,ANY,Seurat,vector-method}
\alias{remove_bg_exp,ANY,character,vector-method}
\alias{remove_bg_exp,ANY,missing,vector-method}
\alias{remove_bg_exp,ANY,ANY,vector-method}
\title{Remove markers with high signal in background data.}
\usage{
remove_bg_exp(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{matrix,matrix,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{DGEList,matrix,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{ANY,DGEList,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{ANY,ExpressionSet,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{ANY,SummarizedExperiment,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{ANY,Seurat,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{ANY,character,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{ANY,missing,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)

\S4method{remove_bg_exp}{ANY,ANY,vector}(
  sig_data,
  bg_data = "CCLE",
  markers,
  s_group_col = NULL,
  s_target_group = NULL,
  b_group_col = NULL,
  b_target_group = NULL,
  snr = 1,
  ...,
  filter = NULL,
  gene_id = "SYMBOL",
  s_slot = "counts",
  b_slot = "counts",
  ccle_tpm = NULL,
  ccle_meta = NULL
)
}
\arguments{
\item{sig_data}{log-transformed expression object, can be matrix or DGEList,
as signal data}

\item{bg_data}{'CCLE' or log-transformed expression object as background data}

\item{markers}{vector, a vector of gene names, listed the gene symbols to be
filtered. Must be gene SYMBOLs}

\item{s_group_col}{vector or character, to specify the group of signal
target_groups, or column name of group, default NULL}

\item{s_target_group}{pattern, specify the target group of interest in
sig_data, default NULL}

\item{b_group_col}{vector or character, to specify the group of background
target_groups, or column name of \code{\link[depmap:metadata]{depmap::depmap_metadata()}},
e.g. 'primary_disease', default NULL}

\item{b_target_group}{pattern, specify the target_group of interest in bg_data,
e.g. 'colorectal', default NULL}

\item{snr}{num, the cutoff of SNR to screen markers which are not or lowly
expressed in bg_data}

\item{...}{params for \code{\link[=grep]{grep()}} to find matched cell lines in bg_data}

\item{filter}{NULL or a vector of 2 num, filter condition to remove low
expression genes in bg_data, the 1st for logcounts,
the 2nd for samples size}

\item{gene_id}{character, specify the gene ID type of rownames of expression
data, could be one of 'ENSEMBL', 'SYMBOL', 'ENTREZ'...,
default 'SYMBOL'}

\item{s_slot}{character, specify which slot to use of DGEList, sce or seurat
object for sig_data, optional, default 'counts'}

\item{b_slot}{character, specify which slot to use of DGEList, sce or seurat
object for bg_data, optional, default 'counts'}

\item{ccle_tpm}{ccle_tpm data from \code{\link[depmap:TPM]{depmap::depmap_TPM()}}, only used when
data = 'CCLE', default NULL}

\item{ccle_meta}{ccle_meta data from \code{\link[depmap:metadata]{depmap::depmap_metadata()}}, only used
when data = 'CCLE', default NULL}
}
\value{
a vector of genes after filtration
}
\description{
Specify signatures against specific tissues or cell lines by
removing genes with high expression in the background.
}
\examples{
data("im_data_6", "nk_markers", "ccle_crc_5")
remove_bg_exp(
  sig_data = Biobase::exprs(im_data_6),
  bg_data = ccle_crc_5,
  im_data_6$`celltype:ch1`, "NK", ## for sig_data
  "cancer", "CRC", ## for bg_data
  markers = nk_markers$HGNC_Symbol[40:50],
  filter = c(1, 2),
  gene_id = c("ENSEMBL", "SYMBOL")
)

}
