% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_wcss}
\alias{compute_wcss}
\title{Compute Whithin-Cluster Sum of Squares}
\usage{
compute_wcss(clusters, cent, data)
}
\arguments{
\item{clusters}{numeric vector with the cluster assignments.}

\item{cent}{numeric matrix with the centroids (clusters in rows, variables
in columns).}

\item{data}{matrix-like object containing the data (numeric or integer).}
}
\value{
A numeric vector with the value of WCSS per cluster.
}
\description{
Given a vector of cluster labels, a matrix of centroids, and a dataset, it
computes the WCSS.
}
\examples{
data = matrix(1:30,nrow = 10)
cl <- mini_batch(data, 2, 10, 10)
compute_wcss(cl$Clusters, cl$centroids, data)

}
