% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_duplicate_motifs.R
\name{has_duplicate_motifs}
\alias{has_duplicate_motifs}
\title{Check for duplicated motif matrices}
\usage{
has_duplicate_motifs(x)
}
\arguments{
\item{x}{a universalmotif list or universalmotif_df}
}
\value{
logical value indicating presence or absence of duplicated motif matrices
}
\description{
This function identifies whether any motif matrices in the input
universalmotif list or universalmotif_df are identical to each other. Note:
this operation is slow on large motif lists
}
\examples{
motif <- universalmotif::create_motif()
duplicated <- c(motif, motif)
has_duplicate_motifs(duplicated)
}
