% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{crossValFit}
\alias{crossValFit}
\title{Cross Validation for Model Fits}
\usage{
crossValFit(
  rts,
  fit,
  vals,
  bs,
  family,
  m,
  method,
  optimizer,
  control,
  message,
  ...
)
}
\arguments{
\item{rts}{data.frame of ordered pair retention times}

\item{fit}{Either "gam" for GAM fits, or "loess" for loess fits}

\item{vals}{numeric vector: k values for GAM fits, spans for loess fits.
Best value chosen by 10-fold cross validation.}

\item{bs}{character. Choice of spline method, either "bs" or "ps"}

\item{family}{character. Choice of mgcv family; see: ?mgcv::family.mgcv}

\item{m}{integer. Basis and penalty order for GAM; see ?mgcv::s}

\item{method}{character. Smoothing parameter estimation method; see:
?mgcv::gam}

\item{optimizer}{character. Method to optimize smoothing parameter; see:
?mgcv::gam}

\item{control}{control parameters for loess fits; see: ?loess.control}

\item{message}{Option to print message indicating function progress}

\item{...}{Other arguments passed to \code{mgcv::gam}.}
}
\value{
Optimal parameter value as determined by 10-fold cross validation
}
\description{
Helper function for \code{fit_gam()} & \code{fit_loess()}. Determines
optimal value of \code{k} basis functions for Generalized Additive Model
fits or \code{span} for loess fits from among user-defined choices,
using a 10-fold cross validation minimizing mean squared error.
}
