% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundance_based_binning.R
\name{abundance_based_binning}
\alias{abundance_based_binning}
\title{Abundance based binning on metagenomic samples}
\usage{
abundance_based_binning(
  ...,
  eMin = 1,
  eMax = 0,
  kMerSizeAB = 10,
  numOfClustersAB = 3,
  outputAB = "AB.cluster",
  keepQuality = FALSE,
  dryRun = FALSE,
  gzip = FALSE,
  numOfThreads = 1
)
}
\arguments{
\item{...}{Input fasta/fastq files locations
(uncompressed or gzip compressed).}

\item{eMin}{Exclude kmers of less or equal count.}

\item{eMax}{Exclude kmers of more or equal count.}

\item{kMerSizeAB}{kmer length for Abundance based Binning.}

\item{numOfClustersAB}{Number of Clusters for Abundance based Binning.}

\item{outputAB}{Output Abundance based Binning Clusters
files location and prefix.}

\item{keepQuality}{Keep fastq qualities on the output files.
(will produce .fastq)}

\item{dryRun}{Don't write any output files.}

\item{gzip}{Gzip output files.}

\item{numOfThreads}{Number of threads to use.}
}
\value{
A \code{\link[base]{data.frame}} of the binning assignments.
    Return value contains \code{numOfClustersAB + 2} columns.
\itemize{
    \item \code{read_id} : read identifier from fasta header
    \item \code{AB} : read was assigned to this AB cluster index
    \item \code{AB.n} : read to cluster AB.n distance
}
}
\description{
This function performs abundance based binning on metagenomic samples,
directly from FASTA or FASTQ files, by long kmer analysis (k>8).
See \doi{10.1186/s12859-016-1186-3} for more details.
}
\examples{
abundance_based_binning(
    system.file("extdata", "reads.metagenome.fasta.gz",package = "metabinR"),
    dryRun = TRUE, kMerSizeAB = 8
)
}
\references{
\url{https://github.com/gkanogiannis/metabinR}
}
\author{
Anestis Gkanogiannis, \email{anestis@gkanogiannis.com}
}
