% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_from_metagene.R
\name{as_is_region_order}
\alias{as_is_region_order}
\title{Returns an "as-is" ordering of regions.}
\usage{
as_is_region_order(metagene)
}
\arguments{
\item{metagene}{The metagene object whose grouped regions should be ordered.}
}
\value{
A list, with as many elements as there are region groups in the
        metagene object. Each element of that list is an ordering of the
        regions of that group based on their original ordering in the 
        metagene2 object.
}
\description{
This function creates an ordering of regions to be used with the 
\code{\link{metagene2_heatmap}} function. The regions are not actually
reordered, but returned as-is.
}
\examples{
  demo_metagene = get_demo_metagene()
  as_is_region_order(demo_metagene)
}
