% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{simInheritance}
\alias{simInheritance}
\title{Simulate a multigenerational methylation experiment with inheritance}
\usage{
simInheritance(pathOut, pref, k, nbCtrl, nbCase, treatment, sample.id,
  generation, stateInfo, propDiff, propDiffsd, diffValue, propInheritance,
  rateDiff, minRate, propInherite, propHetero, minReads, maxPercReads, context,
  assembly, meanCov, diffRes, saveGRanges, saveMethylKit, runAnalysis)
}
\arguments{
\item{pathOut}{a string of \code{character} or \code{NULL}, the path 
where the 
files created by the function will be saved. When \code{NULL}, the files
are saved in the current directory.}

\item{pref}{a string of \code{character} representing the parameters of
specific simulation the string is composed of those elements, separated 
by "_":
\itemize{ 
\item a \code{fileID}
\item the chromosome number, a number between 1 and \code{nbSynCHR}
\item the number of samples, a number in the \code{vNbSample} \code{vector}
\item the mean proportion of samples that has,
for a specific position, differentially methylated values, a 
number in the \code{vpDiff} \code{vector}
\item the proportion of 
C/T for a case differentially methylated that follows a shifted beta 
distribution, a
number in the \code{vDiff} \code{vector}
\item the 
proportion of cases that inherits differentially sites, a number in the
\code{vInheritance} \code{vector}
}}

\item{k}{a positive \code{integer}, an ID for the current simulation.}

\item{nbCtrl}{a positive \code{integer}, the number of controls.}

\item{nbCase}{a positive \code{integer}, the number of cases.}

\item{treatment}{a \code{vector} of integer denoting controls and cases. The
\code{vector} length must correspond to the sum of cases and controls.}

\item{sample.id}{a matrix the name of each samples for each generation (row)
and each case and control (column).}

\item{generation}{a positive \code{integer}, the number of generations
simulated.}

\item{stateInfo}{a \code{GRanges} that contains the CpG (or 
methylated sites).
The \code{GRanges} have four metadata from the real dataset:
\itemize{
\item chrOri a \code{numeric}, the chromosome from the real dataset
\item startOri a \code{numeric}, the position of the site in the real dataset
\item meanCTRL a \code{numeric}, the mean of the control in the real dataset
\item varCTRL a \code{numeric}, the variance of the control in the real 
dataset.
}}

\item{propDiff}{a \code{double} superior to 
\code{0} and inferior or equal 
to \code{1}, the mean value for the proportion of samples that will have,
for a specific position, differentially methylated values. It can be 
interpreted as the penetrance.}

\item{propDiffsd}{a non-negative \code{double}, the 
standard deviation associated to the \code{vpDiff}. Note that 
\code{vpDiff} and \code{vpDiffsd} must be the same length.}

\item{diffValue}{a non-negative \code{double} 
included in [0,1], the proportion of C/T for a case differentially 
methylated that follows 
a beta distribution where the mean is shifted by \code{vDiff} 
from the CTRL distribution.}

\item{propInheritance}{a non-negative \code{double} 
included in [0,1], the proportion of cases 
that inherits differentially methylated sites.}

\item{rateDiff}{a positive \code{double} inferior to \code{1}, the mean of 
the chance that a site is differentially methylated.}

\item{minRate}{a non-negative \code{double} inferior to \code{1}, the 
minimum rate for differentially methylated sites.
Default: \code{0.01}.}

\item{propInherite}{a non-negative \code{double} inferior or equal 
to \code{1}, 
the proportion of differentially methylated regions that 
are inherated.}

\item{propHetero}{a non-negative \code{double} between [0,1], the 
reduction of \code{vDiff} for the second and following generations.}

\item{minReads}{a positive \code{integer}, sites and regions having lower
coverage than this count are discarded. The parameter
corresponds to the \code{lo.count} parameter in 
the \code{methylKit} package.}

\item{maxPercReads}{a \code{double} between [0,100], the percentile of read
counts that is going to be used as upper cutoff. Sites and regions
having higher
coverage than \code{maxPercReads} are discarded. This parameter is used for 
both CpG sites and tiles analysis. The parameter
correspond to the \code{hi.perc} parameter in the \code{methylKit} package.}

\item{context}{a string of \code{character}, the short description of the 
methylation context, such as "CpG", "CpH", "CHH", etc..}

\item{assembly}{a string of \code{character}, the short description of the 
genome assembly, such as "mm9", "hg18", etc..}

\item{meanCov}{a positive \code{integer}, the mean of the coverage
at the simulated CpG sites.}

\item{diffRes}{a \code{list} with 2 entries:
\itemize{
\item \code{stateDiff} a \code{vector} of \code{integer} (\code{0} 
and \code{1}) with length corresponding the length of \code{stateInfo}.
The \code{vector}
indicates, using a \code{1}, the positions where the CpG sites are
differentially methylated.
\item \code{stateInherite} a \code{vector} of \code{integer} (\code{0} and 
\code{1})
with length corresponding the length of \code{stateInfo}. The 
\code{vector}
indicates, using a \code{1}, the positions where the CpG values are
inherited.
} when is \code{NULL} generate a new ones with \code{getDiffMeth}.}

\item{saveGRanges}{a \code{logical}, when \code{true}, the package save two 
files type. The first generate for each simulation contains a \code{list}. 
The length of the \code{list} corresponds to the number of generation. 
The generation are stored in order (first entry = first generation, 
second entry = second generation, etc..). All samples related to one 
generations are contained in a \code{GRangesList}. 
The \code{GRangeaList} store a \code{list} of \code{GRanges}. Each 
\code{GRanges} stores the raw mehylation data of one sample.
The second file a numeric \code{vector} denoting controls and cases 
(a file is generates by entry in the \code{vector} parameters 
\code{vNbSample}).}

\item{saveMethylKit}{a \code{logical}, when \code{TRUE}, the package save 
a file contains a \code{list}. The length of the 
\code{list} corresponds to the number of generation. The generation are 
stored in order (first entry = first generation, 
second entry = second generation, etc..). All samples related to one 
generations are contained in a S4 \code{methylRawList} object. The 
\code{methylRawList} object contains two Slots:
1. treatment: A numeric \code{vector} denoting controls and cases.
2. .Data: A \code{list} of \code{methylRaw} objects. Each object stores the 
raw methylation data of one sample.}

\item{runAnalysis}{a \code{logical}, if \code{TRUE}, two files are saved :
\itemize{
\item 1. The first file is the methylObj... file formated 
with the \code{methylkit} package in a S4 \code{methylBase} 
object (with the \code{methylKit} 
functions: \code{filterByCoverage}, \code{normalizeCoverage} and 
\code{unite}).
\item 2. The second file contains a S4 \code{calculateDiffMeth} object 
generated with the \code{methylKit} functions \code{calculateDiffMeth} 
using the first file.
}}
}
\value{
\code{0} indicating that the function has been successful.
}
\description{
Simulate a multigenerational methylation case versus control 
experiment with inheritance relation using a real control dataset. 

The simulation can be parametrized to fit different models. The number of 
cases and controls, the proportion of the case affected 
by the treatment (penetrance), the effect of the treatment on the mean of 
the distribution, the proportion of sites inherited, the proportion of the 
differentially methylated sites from the precedent generation inherited, 
etc..

The function simulates a multigeneration dataset like a bisulfite 
sequencing experiment. The simulation includes the information about 
control and case for each generation.
}
\examples{

## Name of the directory that will contained the generated files
temp_dir <- "test_simInheritance"

## Load dataset
data(dataSimExample)

## Generate a stateDiff object with length corresponding to
## nbBlock * nbCpG from stateInformation
stateDiff <- list()
stateDiff[["stateDiff"]] <- c(1, 0, 1)
stateDiff[["stateInherite"]] <- c(1, 0, 0)

## Simulate multigenerational methylation experiment with inheritance
methInheritSim:::simInheritance(pathOut = temp_dir,
    pref = "S1_6_0.9_0.8_0.5", k = 1, nbCtrl = 6, nbCase = 6, 
    treatment = dataSimExample$treatment, 
    sample.id = dataSimExample$sample.id,
    generation = 3, stateInfo = dataSimExample$stateInfo[1:3],
    propDiff = 0.9, propDiffsd = 0.1, diffValue = 0.8, 
    propInheritance = 0.5, rateDiff = 0.3, minRate = 0.3,
    propInherite = 0.3, propHetero = 0.5, minReads = 10, maxPercReads = 99, 
    assembly="RNOR_5.0", context="Cpg", meanCov = 40, diffRes = stateDiff,
    saveGRanges = FALSE, saveMethylKit = FALSE, runAnalysis = FALSE)

## Delete directory
if (dir.exists(temp_dir)) {
    unlink(temp_dir, recursive = TRUE, force = FALSE)
}

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
