% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{exportMethylome}
\alias{exportMethylome}
\title{Export a methylome}
\usage{
exportMethylome(model, filename)
}
\arguments{
\item{model}{A \code{\link{methimputeBinomialHMM}} object.}

\item{filename}{The name of the file to be exported.}
}
\value{
\code{NULL}
}
\description{
Export a methylome as a TSV file.
}
\examples{
\dontrun{
## Get some toy data
file <- system.file("data","arabidopsis_toydata.RData", package="methimpute")
data <- get(load(file))
print(data)
model <- callMethylation(data, max.iter=10)
exportMethylome(model, filename = tempfile())
}

}
